/*	blockio.c	1.4	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"

#define SECTS_PER_BLOCK(c)	((c)->blksiz/(c)->seclth)
#define RESERVED_SECTORS(c)	((c)->sectrk*(c)->restrk)

/* Note - BLOCK_SECTOR() adjusts the number to 
   go from 1 to the number of tracks (with the +1)	*/

#define BLOCK_SECTOR(c,bno)	(((bno)*SECTS_PER_BLOCK(c) + RESERVED_SECTORS(c))%(c)->sectrk+1)
#define BLOCK_TRACK(c,bno)	(((bno)*SECTS_PER_BLOCK(c) + RESERVED_SECTORS(c))/(c)->sectrk)
/*
 * Get a full block or a part of a block from floppy disk file
 * nsect gives the actual number of physical sectors to read.
 * if nsect is negative then always read a full block.
 */

cpm_getblock(struct cpmfs *cpmfs, int blockno, char buffer[], int nsect)
{
    int sect, track, counter;

    if (nsect < 0) 
	nsect = SECTS_PER_BLOCK(cpmfs);

    /* Translate block number into logical track/sector address */

    sect = BLOCK_SECTOR(cpmfs,blockno);
    track = BLOCK_TRACK(cpmfs,blockno);

    /* read the block */
    for (counter = 0; counter < nsect; counter++) {
	if (!cpm_getpsect(cpmfs, track, cpmfs->skewtab[sect-1], buffer+(cpmfs->seclth*counter))) {
	    return(FALSE);
	}
	sect++;
	if (sect > cpmfs->sectrk) {
	    sect = 1;
	    track++;
	}
    }

    return (TRUE);
}

/*
 * Save a full block or a part of a block in floppy disk file
 * If nsects is negative, write a full block.
 */

cpm_putblock(struct cpmfs *cpmfs, int blockno, char buffer[], int nsect)
{

    int sect, track, counter;

    if (nsect < 0) 
	nsect = SECTS_PER_BLOCK(cpmfs);

    /* Translate block number into logical track/sector address */

    sect = BLOCK_SECTOR(cpmfs,blockno);
    track = BLOCK_TRACK(cpmfs,blockno);

    /* write the block */
    for (counter = 0; counter < nsect; counter++) {
	if (!cpm_putpsect(cpmfs, track, cpmfs->skewtab[sect-1],buffer+(cpmfs->seclth*counter))) {
	    return(FALSE);
	}
	sect++;
	if (sect > cpmfs->sectrk) {
	    sect = 1;
	    track++;
	}
    }
    return (TRUE);
}
